<?php

$hudson_edge_icon_collections = hudson_edge_return_icon_collections();
$titlePage = new HudsonEdgeAdminPage(
	"4",
	esc_html__( "Title", 'hudson' ),
	"fa fa-list-alt"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"title",
	$titlePage
);

$panel8 = new HudsonEdgePanel(
	esc_html__( "Title", 'hudson' ),
	"title_panel"
);
$titlePage->addChild(
	"panel8",
	$panel8
);

$show_page_title = new HudsonEdgeField(
	"yesno",
	"show_page_title",
	"yes",
	esc_html__( "Enable Page Title Area", 'hudson' ),
	esc_html__( "This option will enable Title Area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_title_container"
	)
);
$panel8->addChild(
	"show_page_title",
	$show_page_title
);

$enable_title_container = new HudsonEdgeContainer(
	"enable_title_container",
	"show_page_title",
	"no"
);
$panel8->addChild(
	"enable_title_container",
	$enable_title_container
);

$title_type = new HudsonEdgeField(
	"select",
	"title_type",
	"standard_title",
	esc_html__( "Title Type", 'hudson' ),
	esc_html__( "Choose title type", 'hudson' ),
	array(
		"standard_title" => esc_html__( "Standard", 'hudson' ),
		"breadcrumbs_title" => esc_html__( "Breadcrumb", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "breadcrumbs_title" => "#edgtf_title_standard_container" ),
		"show"       => array( "standard_title" => "#edgtf_title_standard_container" )
	)
);
$enable_title_container->addChild(
	"title_type",
	$title_type
);

$animate_title_area = new HudsonEdgeField(
	"select",
	"animate_title_area",
	"no",
	esc_html__( "Animations", 'hudson' ),
	esc_html__( "Choose an animation for Title Area", 'hudson' ),
	array(
		"no" => esc_html__( "No animation", 'hudson' ),
		"text_right_left" => esc_html__( "Text right to left", 'hudson' ),
		"area_top_bottom" => esc_html__( "Title area top to bottom", 'hudson' )
	)
);
$enable_title_container->addChild(
	"animate_title_area",
	$animate_title_area
);

$page_title_vertical_aligment = new HudsonEdgeField(
	"select",
	"page_title_vertical_aligment",
	"header_bottom",
	esc_html__( "Vertical Alignment", 'hudson' ),
	esc_html__( "Specify Title vertical alignment", 'hudson' ),
	array(
		"header_bottom" => esc_html__( "From Bottom of Header", 'hudson' ),
		"window_top" => esc_html__( "From Window Top", 'hudson' )
	)
);
$enable_title_container->addChild(
	"page_title_vertical_aligment",
	$page_title_vertical_aligment
);

$show_page_title_text = new HudsonEdgeField(
	"yesno",
	"show_page_title_text",
	"yes",
	esc_html__( "Enable Page Title Text", 'hudson' ),
	esc_html__( "This option will enable Title Text", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_title_text_container, #edgtf_animation_page_title_contaier"
	)
);
$enable_title_container->addChild(
	"show_page_title_text",
	$show_page_title_text
);

$enable_title_text_container = new HudsonEdgeContainer(
	"enable_title_text_container",
	"show_page_title_text",
	"no"
);
$enable_title_container->addChild(
	"enable_title_text_container",
	$enable_title_text_container
);

$predefined_title_sizes = new HudsonEdgeField(
	"select",
	"predefined_title_sizes",
	"small",
	esc_html__( "Text Size", 'hudson' ),
	esc_html__( "Choose a default Title size", 'hudson' ),
	array(
		"small" => esc_html__( "Small", 'hudson' ),
		"medium" => esc_html__( "Medium", 'hudson' ),
		"large" => esc_html__( "Large", 'hudson' )
	)
);
$enable_title_text_container->addChild(
	"predefined_title_sizes",
	$predefined_title_sizes
);

$page_title_position = new HudsonEdgeField(
	"select",
	"page_title_position",
	"center",
	esc_html__( "Title Text Alignment", 'hudson' ),
	esc_html__( "Specify Title text alignment", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$enable_title_text_container->addChild(
	"page_title_position",
	$page_title_position
);

$title_text_shadow = new HudsonEdgeField(
	"yesno",
	"title_text_shadow",
	"no",
	esc_html__( "Title Text Shadow", 'hudson' ),
	esc_html__( "Enabling this option will give Title text a shadow", 'hudson' )
);
$enable_title_text_container->addChild(
	"title_text_shadow",
	$title_text_shadow
);

$title_standard_container = new HudsonEdgeContainer(
	"title_standard_container",
	"title_type",
	"breadcrumbs_title"
);
$enable_title_container->addChild(
	"title_standard_container",
	$title_standard_container
);

//Title like separator with text
$title_like_separator = new HudsonEdgeField(
	"yesno",
	"title_like_separator",
	"no",
	esc_html__( "Separator Around Title Text", 'hudson' ),
	esc_html__( "Enable separator around title", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_title_like_separator_container"
	)
);
$title_standard_container->addChild(
	"title_like_separator",
	$title_like_separator
);

$title_like_separator_container = new HudsonEdgeContainer(
	"title_like_separator_container",
	"title_like_separator",
	"no"
);
$title_standard_container->addChild(
	"title_like_separator_container",
	$title_like_separator_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Line Styles", 'hudson' ),
	esc_html__( "Choose style for separator line", 'hudson' )
);
$title_like_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_like_separator_line_color = new HudsonEdgeField(
	"colorsimple",
	"title_like_separator_line_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_like_separator_line_color",
	$title_like_separator_line_color
);

$title_like_separator_line_width = new HudsonEdgeField(
	"textsimple",
	"title_like_separator_line_width",
	"",
	esc_html__( "Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_like_separator_line_width",
	$title_like_separator_line_width
);

$title_like_separator_line_thickness = new HudsonEdgeField(
	"textsimple",
	"title_like_separator_line_thickness",
	"",
	esc_html__( "Thickness", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_like_separator_line_thickness",
	$title_like_separator_line_thickness
);

$title_like_separator_line_style = new HudsonEdgeField(
	"selectsimple",
	"title_like_separator_line_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$row1->addChild(
	"title_like_separator_line_style",
	$title_like_separator_line_style
);

$title_like_separator_margins = new HudsonEdgeField(
	"text",
	"title_like_separator_margins",
	"",
	esc_html__( "Margins for Title", 'hudson' ),
	esc_html__( "Define left/right margins for title from separator", 'hudson' )
);
$title_like_separator_container->addChild(
	"title_like_separator_margins",
	$title_like_separator_margins
);

$title_like_separator_line_dots = new HudsonEdgeField(
	"yesno",
	"title_like_separator_line_dots",
	"no",
	esc_html__( "Dots on The End of Lines", 'hudson' ),
	esc_html__( "Enabling this option will give lines a dot next to title", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_title_like_separator_dots_container"
	)
);
$title_like_separator_container->addChild(
	"title_like_separator_line_dots",
	$title_like_separator_line_dots
);

$title_like_separator_dots_container = new HudsonEdgeContainer(
	"title_like_separator_dots_container",
	"title_like_separator_line_dots",
	"no"
);
$title_like_separator_container->addChild(
	"title_like_separator_dots_container",
	$title_like_separator_dots_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Dots Style", 'hudson' ),
	esc_html__( "Choose style for dots", 'hudson' )
);
$title_like_separator_dots_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_like_separator_dots_size = new HudsonEdgeField(
	"textsimple",
	"title_like_separator_dots_size",
	"",
	esc_html__( "Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_like_separator_dots_size",
	$title_like_separator_dots_size
);

$title_like_separator_dots_color = new HudsonEdgeField(
	"colorsimple",
	"title_like_separator_dots_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_like_separator_dots_color",
	$title_like_separator_dots_color
);

//Subtitle like separator with text
$subtitle_like_separator = new HudsonEdgeField(
	"yesno",
	"subtitle_like_separator",
	"no",
	esc_html__( "Separator Around Subtitle Text", 'hudson' ),
	esc_html__( "Enable separator around subtitle", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_subtitle_like_separator_container"
	)
);
$title_standard_container->addChild(
	"subtitle_like_separator",
	$subtitle_like_separator
);

$subtitle_like_separator_container = new HudsonEdgeContainer(
	"subtitle_like_separator_container",
	"subtitle_like_separator",
	"no"
);
$title_standard_container->addChild(
	"subtitle_like_separator_container",
	$subtitle_like_separator_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Line Styles", 'hudson' ),
	esc_html__( "Choose style for separator line", 'hudson' )
);
$subtitle_like_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$subtitle_like_separator_line_color = new HudsonEdgeField(
	"colorsimple",
	"subtitle_like_separator_line_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"subtitle_like_separator_line_color",
	$subtitle_like_separator_line_color
);

$subtitle_like_separator_line_width = new HudsonEdgeField(
	"textsimple",
	"subtitle_like_separator_line_width",
	"",
	esc_html__( "Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"subtitle_like_separator_line_width",
	$subtitle_like_separator_line_width
);

$subtitle_like_separator_line_thickness = new HudsonEdgeField(
	"textsimple",
	"subtitle_like_separator_line_thickness",
	"",
	esc_html__( "Thickness", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"subtitle_like_separator_line_thickness",
	$subtitle_like_separator_line_thickness
);

$subtitle_like_separator_line_style = new HudsonEdgeField(
	"selectsimple",
	"subtitle_like_separator_line_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$row1->addChild(
	"subtitle_like_separator_line_style",
	$subtitle_like_separator_line_style
);

$subtitle_like_separator_margins = new HudsonEdgeField(
	"text",
	"subtitle_like_separator_margins",
	"",
	esc_html__( "Margins for Subtitle", 'hudson' ),
	esc_html__( "Define left/right margins for subtitle from separator", 'hudson' )
);
$subtitle_like_separator_container->addChild(
	"subtitle_like_separator_margins",
	$subtitle_like_separator_margins
);

$subtitle_like_separator_animation = new HudsonEdgeField(
	"yesno",
	"subtitle_like_separator_animation",
	"no",
	esc_html__( "Animate Width", 'hudson' ),
	esc_html__( "Enabling this option will animate width of the separator", 'hudson' )
);
$subtitle_like_separator_container->addChild(
	"subtitle_like_separator_animation",
	$subtitle_like_separator_animation
);

$title_background_color = new HudsonEdgeField(
	"color",
	"title_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Title Area", 'hudson' )
);
$enable_title_container->addChild(
	"title_background_color",
	$title_background_color
);

$title_image = new HudsonEdgeField(
	"image",
	"title_image",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose an Image for Title Area", 'hudson' )
);
$enable_title_container->addChild(
	"title_image",
	$title_image
);

$title_pattern = new HudsonEdgeField(
	"image",
	"title_pattern",
	HUDSON_EDGE_ROOT . "/img/title_background_pattern.png",
	esc_html__( "Background Pattern", 'hudson' ),
	esc_html__( "Choose an Pattern for Title Area", 'hudson' )
);
$enable_title_container->addChild(
	"title_pattern",
	$title_pattern
);

$responsive_title_image = new HudsonEdgeField(
	"yesno",
	"responsive_title_image",
	"no",
	esc_html__( "Background Responsive Image", 'hudson' ),
	esc_html__( "Enabling this option will make Title background image responsive", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_responsive_title_image_container",
		"dependence_show_on_yes" => ""
	)
);
$enable_title_container->addChild(
	"responsive_title_image",
	$responsive_title_image
);

$responsive_title_image_container = new HudsonEdgeContainer(
	"responsive_title_image_container",
	"responsive_title_image",
	"yes"
);
$enable_title_container->addChild(
	"responsive_title_image_container",
	$responsive_title_image_container
);
$fixed_title_image = new HudsonEdgeField(
	"select",
	"fixed_title_image",
	"no",
	esc_html__( "Parallax Title Image", 'hudson' ),
	esc_html__( "Enabling this option will make Title image parallax", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' ),
		"yes_zoom" => esc_html__( "Yes, with zoom out", 'hudson' )
	)
);
$responsive_title_image_container->addChild(
	"fixed_title_image",
	$fixed_title_image
);
$title_height = new HudsonEdgeField(
	"text",
	"title_height",
	"",
	esc_html__( "Title Height (px)", 'hudson' ),
	esc_html__( "Set a height for Title Area in pixels", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$responsive_title_image_container->addChild(
	"title_height",
	$title_height
);

$title_overlay_image = new HudsonEdgeField(
	"image",
	"title_overlay_image",
	"",
	esc_html__( "Pattern Overlay Image", 'hudson' ),
	esc_html__( "Choose an image to be used as pattern over Title Area", 'hudson' )
);
$enable_title_container->addChild(
	"title_overlay_image",
	$title_overlay_image
);

$title_separator = new HudsonEdgeField(
	"yesno",
	"title_separator",
	"no",
	esc_html__( "Show Title Separator", 'hudson' ),
	esc_html__( "Enabling this option will display a separator underneath Title", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_title_separator_container, #edgtf_animation_page_title_separator_container"
	)
);
$title_standard_container->addChild(
	"title_separator",
	$title_separator
);

$title_separator_container = new HudsonEdgeContainer(
	"title_separator_container",
	"title_separator",
	"no"
);
$title_standard_container->addChild(
	"title_separator_container",
	$title_separator_container
);

$title_separator_format = new HudsonEdgeField(
	"select",
	"title_separator_format",
	"normal",
	esc_html__( "Format", 'hudson' ),
	esc_html__( "Choose a format (type) of separator", 'hudson' ),
	array(
		"normal" => esc_html__( "Normal", 'hudson' ),
		"with_icon" => esc_html__( "With Icon", 'hudson' ),
		"with_custom_icon" => esc_html__( "With Custom Icon", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"normal"           => "#edgtf_separator_with_icon_container, #edgtf_separator_custom_icon_container, #edgtf_separator_all_icons_container",
			"with_custom_icon" => "#edgtf_separator_with_icon_container",
			"with_icon"        => "#edgtf_separator_custom_icon_container"
		),
		"show"       => array(
			"with_icon"        => "#edgtf_separator_with_icon_container, #edgtf_separator_all_icons_container",
			"with_custom_icon" => "#edgtf_separator_custom_icon_container, #edgtf_separator_all_icons_container"
		)
	)
);

$title_separator_container->addChild(
	"title_separator_format",
	$title_separator_format
);

$separator_all_icons_container = new HudsonEdgeContainer(
	"separator_all_icons_container",
	"title_separator_format",
	"normal"
);
$title_separator_container->addChild(
	"separator_all_icons_container",
	$separator_all_icons_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Icon Position and Margins", 'hudson' ),
	esc_html__( "Choose icon position and set left(right) margin", 'hudson' )
);
$separator_all_icons_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_separator_icon_position = new HudsonEdgeField(
	"selectsimple",
	"title_separator_icon_position",
	"",
	esc_html__( "Icon Position", 'hudson' ),
	esc_html__( "Choose a position for an icon", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$row1->addChild(
	"title_separator_icon_position",
	$title_separator_icon_position
);

$title_separator_icon_margins = new HudsonEdgeField(
	"textsimple",
	"title_separator_icon_margins",
	"",
	esc_html__( "Margins (px)", 'hudson' ),
	esc_html__( "Enter margin that will refer to left and right margin of the icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_margins",
	$title_separator_icon_margins
);

$separator_with_icon_container = new HudsonEdgeContainer(
	"separator_with_icon_container",
	"title_separator_format",
	"normal",
	array( "normal", "with_custom_icon" )
);
$title_separator_container->addChild(
	"separator_with_icon_container",
	$separator_with_icon_container
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$separator_icon_pack_hide_array = array();
$separator_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$separator_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$separator_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$separator_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_separator_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $separator_icon_collections_params as $separator_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $separator_icon_collections_param !== $dep_collection_object->param ) {
				$separator_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_separator_icon_' . $separator_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$separator_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$separator_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$separator_icon_pack = new HudsonEdgeField(
	"select",
	"separator_icon_pack",
	"font_awesome",
	esc_html__( "Separator Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for separator", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $separator_icon_pack_hide_array,
		"show"       => $separator_icon_pack_show_array
	)
);

$separator_with_icon_container->addChild(
	"separator_icon_pack",
	$separator_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$separator_icon_hide_values = $icon_collections_keys;
		$separator_icon_container   = new HudsonEdgeContainer(
			"separator_icon_" . $collection_object->param . "_container",
			"separator_icon_pack",
			"",
			$separator_icon_hide_values
		);
		$separator_icon             = new HudsonEdgeField(
			"select",
			"separator_icon_" . $collection_object->param,
			"",
			esc_html__( "Separator Icon", 'hudson' ),
			esc_html__( "Choose Separator Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$separator_icon_container->addChild(
			"separator_icon_" . $collection_object->param,
			$separator_icon
		);
		
		$separator_with_icon_container->addChild(
			"separator_icon_" . $collection_object->param . "_container",
			$separator_icon_container
		);
	}
	
}

$group1 = new HudsonEdgeGroup(
	esc_html__( "Icon Style", 'hudson' ),
	esc_html__( "Choose icon style", 'hudson' )
);
$separator_with_icon_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_separator_icon_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color of icon for Title separator", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_color",
	$title_separator_icon_color
);

$title_separator_icon_hover_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color of icon for Title separator", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_hover_color",
	$title_separator_icon_hover_color
);

$title_separator_icon_custom_size = new HudsonEdgeField(
	"textsimple",
	"title_separator_icon_custom_size",
	"",
	esc_html__( "Icon Size", 'hudson' ),
	esc_html__( "Choose size of icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_custom_size",
	$title_separator_icon_custom_size
);

$title_separator_icon_type = new HudsonEdgeField(
	"select",
	"title_separator_icon_type",
	"normal",
	esc_html__( "Icon Type", 'hudson' ),
	esc_html__( "Choose icon type", 'hudson' ),
	array(
		"normal" => esc_html__( "Normal", 'hudson' ),
		"circle" => esc_html__( "Circle", 'hudson' ),
		"square" => esc_html__( "Square", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "normal" => "#edgtf_title_separator_types_container" ),
		"show"       => array(
			"circle" => "#edgtf_title_separator_types_container",
			"square" => "#edgtf_title_separator_types_container"
		)
	)
);
$separator_with_icon_container->addChild(
	"title_separator_icon_type",
	$title_separator_icon_type
);

$title_separator_types_container = new HudsonEdgeContainer(
	"title_separator_types_container",
	"title_separator_icon_type",
	"normal"
);
$separator_with_icon_container->addChild(
	"title_separator_types_container",
	$title_separator_types_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Define border style for icon", 'hudson' )
);
$title_separator_types_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_separator_icon_border_radius = new HudsonEdgeField(
	"textsimple",
	"title_separator_icon_border_radius",
	"",
	esc_html__( "Border Radius (px)", 'hudson' ),
	esc_html__( "Enter border radius for icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_border_radius",
	$title_separator_icon_border_radius
);

$title_separator_icon_border_width = new HudsonEdgeField(
	"textsimple",
	"title_separator_icon_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "Enter border width for icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_border_width",
	$title_separator_icon_border_width
);

$title_separator_icon_border_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Enter border color for icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_border_color",
	$title_separator_icon_border_color
);

$title_separator_icon_border_hover_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_border_hover_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "Enter border color for icon", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_border_hover_color",
	$title_separator_icon_border_hover_color
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Additional Icon Style", 'hudson' ),
	esc_html__( "Choose adition icon styling", 'hudson' )
);
$title_separator_types_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$title_separator_icon_shape_size = new HudsonEdgeField(
	"textsimple",
	"title_separator_icon_shape_size",
	"",
	esc_html__( "Shape Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_shape_size",
	$title_separator_icon_shape_size
);

$title_separator_icon_background_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_background_color",
	$title_separator_icon_background_color
);

$title_separator_icon_background_hover_color = new HudsonEdgeField(
	"colorsimple",
	"title_separator_icon_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_icon_background_hover_color",
	$title_separator_icon_background_hover_color
);

$separator_custom_icon_container = new HudsonEdgeContainer(
	"separator_custom_icon_container",
	"title_separator_format",
	"normal",
	array( "normal", "with_icon" )
);
$title_separator_container->addChild(
	"separator_custom_icon_container",
	$separator_custom_icon_container
);

$separator_custom_icon = new HudsonEdgeField(
	"image",
	"separator_custom_icon",
	"",
	esc_html__( "Custom Icon", 'hudson' ),
	esc_html__( "Choose custom icon for separator", 'hudson' )
);
$separator_custom_icon_container->addChild(
	"separator_custom_icon",
	$separator_custom_icon
);

$title_separator_type = new HudsonEdgeField(
	"select",
	"title_separator_type",
	"",
	esc_html__( "Type", 'hudson' ),
	esc_html__( "Choose a Title separator line style", 'hudson' ),
	array(
		""       => "",
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' )
	)
);
$title_separator_container->addChild(
	"title_separator_type",
	$title_separator_type
);

$title_separator_position = new HudsonEdgeField(
	"select",
	"title_separator_position",
	"",
	esc_html__( "Position", 'hudson' ),
	esc_html__( "Choose a Title separator position", 'hudson' ),
	array(
		""      => "",
		"above" => esc_html__( "Above Title", 'hudson' ),
		"below" => esc_html__( "Below Title", 'hudson' )
	)
);
$title_separator_container->addChild(
	"title_separator_position",
	$title_separator_position
);

$title_separator_color = new HudsonEdgeField(
	"color",
	"title_separator_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for Title separator", 'hudson' )
);
$title_separator_container->addChild(
	"title_separator_color",
	$title_separator_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Size", 'hudson' ),
	esc_html__( 'Define size for Title separator', 'hudson' )
);
$title_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_separator_thickness = new HudsonEdgeField(
	"textsimple",
	"title_separator_thickness",
	"",
	esc_html__( "Thickness (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_thickness",
	$title_separator_thickness
);

$title_separator_width = new HudsonEdgeField(
	"textsimple",
	"title_separator_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_width",
	$title_separator_width
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Margin", 'hudson' ),
	esc_html__( 'Add space at top and bottom of Title separator', 'hudson' )
);
$title_separator_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$title_separator_topmargin = new HudsonEdgeField(
	"textsimple",
	"title_separator_topmargin",
	"",
	esc_html__( "Top Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_topmargin",
	$title_separator_topmargin
);

$title_separator_bottommargin = new HudsonEdgeField(
	"textsimple",
	"title_separator_bottommargin",
	"",
	esc_html__( "Bottom Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"title_separator_bottommargin",
	$title_separator_bottommargin
);

$border_top_title_area = new HudsonEdgeField(
	"yesno",
	"border_top_title_area",
	"yes",
	esc_html__( "Top Border", 'hudson' ),
	esc_html__( "Enabling this option will display top border on Title Area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_border_top_title_area_container"
	)
);
$enable_title_container->addChild(
	"border_top_title_area",
	$border_top_title_area
);

$border_top_title_area_container = new HudsonEdgeContainer(
	"border_top_title_area_container",
	"border_top_title_area",
	"no"
);
$enable_title_container->addChild(
	"border_top_title_area_container",
	$border_top_title_area_container
);

$enable_title_border_top_grid = new HudsonEdgeField(
	"yesno",
	"enable_title_border_top_grid",
	"no",
	esc_html__( "Enable Border in Grid", 'hudson' ),
	esc_html__( "This option will show title top border in grid", 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => ''
	)
);
$border_top_title_area_container->addChild(
	"enable_title_border_top_grid",
	$enable_title_border_top_grid
);

$border_top_title_area_width = new HudsonEdgeField(
	"text",
	"border_top_title_area_width",
	"",
	esc_html__( "Top Border Width (px)", 'hudson' ),
	esc_html__( "Choose a width for Title Area top border Note: If width has not been set, border top will not be displayed", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$border_top_title_area_container->addChild(
	"border_top_title_area_width",
	$border_top_title_area_width
);
$border_top_title_area_color = new HudsonEdgeField(
	"color",
	"border_top_title_area_color",
	"",
	esc_html__( "Top Border Color", 'hudson' ),
	esc_html__( "Choose a color for Title Area top border", 'hudson' )
);
$border_top_title_area_container->addChild(
	"border_top_title_area_color",
	$border_top_title_area_color
);

$border_bottom_title_area = new HudsonEdgeField(
	"yesno",
	"border_bottom_title_area",
	"yes",
	esc_html__( "Bottom Border", 'hudson' ),
	esc_html__( "Enabling this option will display bottom border on Title Area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_border_bottom_title_area_container"
	)
);
$enable_title_container->addChild(
	"border_bottom_title_area",
	$border_bottom_title_area
);

$border_bottom_title_area_container = new HudsonEdgeContainer(
	"border_bottom_title_area_container",
	"border_bottom_title_area",
	"no"
);
$enable_title_container->addChild(
	"border_bottom_title_area_container",
	$border_bottom_title_area_container
);

$enable_title_border_grid = new HudsonEdgeField(
	"yesno",
	"enable_title_border_grid",
	"no",
	esc_html__( "Enable Border in Grid", 'hudson' ),
	esc_html__( "This option will show title bottom border in grid", 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => ''
	)
);
$border_bottom_title_area_container->addChild(
	"enable_title_border_grid",
	$enable_title_border_grid
);

$border_bottom_title_area_width = new HudsonEdgeField(
	"text",
	"border_bottom_title_area_width",
	"",
	esc_html__( "Bottom Border Width (px)", 'hudson' ),
	esc_html__( "Choose a width for Title Area bottom border Note: If width has not been set, border bottom will not be displayed", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$border_bottom_title_area_container->addChild(
	"border_bottom_title_area_width",
	$border_bottom_title_area_width
);
$border_bottom_title_area_color = new HudsonEdgeField(
	"color",
	"border_bottom_title_area_color",
	"",
	esc_html__( "Bottom Border Color", 'hudson' ),
	esc_html__( "Choose a color for Title Area bottom border", 'hudson' )
);
$border_bottom_title_area_container->addChild(
	"border_bottom_title_area_color",
	$border_bottom_title_area_color
);

$enable_breadcrumbs = new HudsonEdgeField(
	"yesno",
	"enable_breadcrumbs",
	"no",
	esc_html__( "Enable Breadcrumbs", 'hudson' ),
	esc_html__( "This option will display Breadcrumbs in Title Area", 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_animation_page_title_breadcrumbs_container'
	)
);
$enable_title_container->addChild(
	"enable_breadcrumbs",
	$enable_breadcrumbs
);

$title_graphics = new HudsonEdgeField(
	"image",
	"title_graphics",
	"",
	esc_html__( "Graphics", 'hudson' ),
	esc_html__( "Choose graphics", 'hudson' )
);
$title_standard_container->addChild(
	"title_graphics",
	$title_graphics
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title Area Content Style", 'hudson' ),
	esc_html__( 'Define style for Title Area Content', 'hudson' )
);
$enable_title_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$title_content_background_color = new HudsonEdgeField(
	"colorsimple",
	"title_content_background_color",
	"",
	esc_html__( "Title Content Background Color", 'hudson' ),
	esc_html__( "Background color for title content", 'hudson' )
);
$row1->addChild(
	"title_content_background_color",
	$title_content_background_color
);

$title_content_background_opacity = new HudsonEdgeField(
	"textsimple",
	"title_content_background_opacity",
	"",
	esc_html__( "Title Content Background Opacity", 'hudson' ),
	esc_html__( "Choose opacity for background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"title_content_background_opacity",
	$title_content_background_opacity
);

$title_content_in_grid = new HudsonEdgeField(
	"yesno",
	"title_content_in_grid",
	"yes",
	esc_html__( "Title Area Content In Grid", 'hudson' ),
	esc_html__( "This option will show title area content in grid", 'hudson' )
);
$enable_title_container->addChild(
	"title_content_in_grid",
	$title_content_in_grid
);

$title_content_shadows = new HudsonEdgeField(
	'yesno',
	'title_content_shadows',
	'no',
	esc_html__( 'Show Title Content Area Shadows', 'hudson' ),
	esc_html__( 'Enabling this option will show shadows on title content area', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_title_content_shadows_container'
	)
);
$enable_title_container->addChild(
	'title_content_shadows',
	$title_content_shadows
);

$title_content_shadows_container = new HudsonEdgeContainer(
	'title_content_shadows_container',
	'title_content_shadows',
	'no'
);
$enable_title_container->addChild(
	'title_content_shadows_container',
	$title_content_shadows_container
);

$group7 = new HudsonEdgeGroup(
	esc_html__( 'Title Content Area Shadows', 'hudson' ),
	esc_html__( 'Set horizontal and vertical position of shadow (negative values are allowed), and define blur and spread.', 'hudson' )
);
$title_content_shadows_container->addChild(
	'group7',
	$group7
);

$row1 = new HudsonEdgeRow();
$group7->addChild(
	'row1',
	$row1
);

$title_content_shadow_horizontal_shadow = new HudsonEdgeField(
	'textsimple',
	'title_content_shadow_horizontal_shadow',
	'',
	esc_html__( 'Horizontal Shadow (px)', 'hudson' )
);
$row1->addChild(
	'title_content_shadow_horizontal_shadow',
	$title_content_shadow_horizontal_shadow
);

$title_content_shadow_vertical_shadow = new HudsonEdgeField(
	'textsimple',
	'title_content_shadow_vertical_shadow',
	'',
	esc_html__( 'Vertical Shadow (px)', 'hudson' )
);
$row1->addChild(
	'title_content_shadow_vertical_shadow',
	$title_content_shadow_vertical_shadow
);

$title_content_shadow_blur_distance = new HudsonEdgeField(
	'textsimple',
	'title_content_shadow_blur_distance',
	'',
	esc_html__( 'Blur (px)', 'hudson' )
);
$row1->addChild(
	'title_content_shadow_blur_distance',
	$title_content_shadow_blur_distance
);

$title_content_shadow_shadow_size = new HudsonEdgeField(
	'textsimple',
	'title_content_shadow_shadow_size',
	'',
	esc_html__( 'Spread (px)', 'hudson' )
);
$row1->addChild(
	'title_content_shadow_shadow_size',
	$title_content_shadow_shadow_size
);

$row2 = new HudsonEdgeRow( true );
$group7->addChild(
	'row2',
	$row2
);

$title_content_shadow_shadow_color = new HudsonEdgeField(
	'colorsimple',
	'title_content_shadow_shadow_color',
	'',
	esc_html__( 'Shadow color', 'hudson' )
);
$row2->addChild(
	'title_content_shadow_shadow_color',
	$title_content_shadow_shadow_color
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Title Area Content Padding", 'hudson' ),
	esc_html__( "Define padding for title area content", 'hudson' )
);
$enable_title_container->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$title_content_span_top_padding = new HudsonEdgeField(
	"textsimple",
	"title_content_span_top_padding",
	"",
	esc_html__( "Top Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_content_span_top_padding",
	$title_content_span_top_padding
);

$title_content_span_right_padding = new HudsonEdgeField(
	"textsimple",
	"title_content_span_right_padding",
	"",
	esc_html__( "Right Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_content_span_right_padding",
	$title_content_span_right_padding
);

$title_content_span_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"title_content_span_bottom_padding",
	"",
	esc_html__( "Bottom Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_content_span_bottom_padding",
	$title_content_span_bottom_padding
);

$title_content_span_left_padding = new HudsonEdgeField(
	"textsimple",
	"title_content_span_left_padding",
	"",
	esc_html__( "Left Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_content_span_left_padding",
	$title_content_span_left_padding
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Title Style", 'hudson' ),
	esc_html__( 'Define style for Title', 'hudson' )
);
$enable_title_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$title_span_background_color = new HudsonEdgeField(
	"colorsimple",
	"title_span_background_color",
	"",
	esc_html__( "Title Background Color", 'hudson' ),
	esc_html__( "Background color for title", 'hudson' )
);
$row1->addChild(
	"title_span_background_color",
	$title_span_background_color
);

$title_span_background_opacity = new HudsonEdgeField(
	"textsimple",
	"title_span_background_opacity",
	"",
	esc_html__( "Title Background Opacity", 'hudson' ),
	esc_html__( "Choose opacity for background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"title_span_background_opacity",
	$title_span_background_opacity
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Title Padding", 'hudson' ),
	esc_html__( 'Define padding for Title', 'hudson' )
);
$enable_title_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$title_span_top_padding = new HudsonEdgeField(
	"textsimple",
	"title_span_top_padding",
	"",
	esc_html__( "Top Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_span_top_padding",
	$title_span_top_padding
);

$title_span_right_padding = new HudsonEdgeField(
	"textsimple",
	"title_span_right_padding",
	"",
	esc_html__( "Right Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_span_right_padding",
	$title_span_right_padding
);

$title_span_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"title_span_bottom_padding",
	"",
	esc_html__( "Bottom Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_span_bottom_padding",
	$title_span_bottom_padding
);

$title_span_left_padding = new HudsonEdgeField(
	"textsimple",
	"title_span_left_padding",
	"",
	esc_html__( "Left Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"title_span_left_padding",
	$title_span_left_padding
);

$subtitle_position = new HudsonEdgeField(
	"select",
	"subtitle_position",
	"below_title",
	esc_html__( "Subtitle Position", 'hudson' ),
	esc_html__( "Choose a Subtitle position", 'hudson' ),
	array(
		"below_title" => esc_html__( "Below Title", 'hudson' ),
		"above_title" => esc_html__( "Above Title", 'hudson' ),
		"next_to_title" => esc_html__( "Next to Title", 'hudson' )
	)
);
$enable_title_container->addChild(
	"subtitle_position",
	$subtitle_position
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Subtitle Style", 'hudson' ),
	esc_html__( 'Define style for subtitle', 'hudson' )
);
$enable_title_container->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$subtitle_span_background_color = new HudsonEdgeField(
	"colorsimple",
	"subtitle_span_background_color",
	"",
	esc_html__( "Subtitle Background Color", 'hudson' ),
	esc_html__( "Background color for subtitle", 'hudson' )
);
$row1->addChild(
	"subtitle_span_background_color",
	$subtitle_span_background_color
);

$subtitle_span_background_opacity = new HudsonEdgeField(
	"textsimple",
	"subtitle_span_background_opacity",
	"",
	esc_html__( "Subtitle Background Opacity", 'hudson' ),
	esc_html__( "Choose opacity for background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"subtitle_span_background_opacity",
	$subtitle_span_background_opacity
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Subtitle Padding", 'hudson' ),
	esc_html__( 'Define padding for subtitle', 'hudson' )
);
$enable_title_container->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);

$subtitle_span_top_padding = new HudsonEdgeField(
	"textsimple",
	"subtitle_span_top_padding",
	"",
	esc_html__( "Top Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"subtitle_span_top_padding",
	$subtitle_span_top_padding
);

$subtitle_span_right_padding = new HudsonEdgeField(
	"textsimple",
	"subtitle_span_right_padding",
	"",
	esc_html__( "Right Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"subtitle_span_right_padding",
	$subtitle_span_right_padding
);

$subtitle_span_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"subtitle_span_bottom_padding",
	"",
	esc_html__( "Bottom Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"subtitle_span_bottom_padding",
	$subtitle_span_bottom_padding
);

$subtitle_span_left_padding = new HudsonEdgeField(
	"textsimple",
	"subtitle_span_left_padding",
	"",
	esc_html__( "Left Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"subtitle_span_left_padding",
	$subtitle_span_left_padding
);

$panel9 = new HudsonEdgePanel(
	esc_html__( 'Title Animations', 'hudson' ),
	'title_animations'
);
$titlePage->addChild(
	'panel9',
	$panel9
);

//Whole title content animation
$page_title_whole_content_animations = new HudsonEdgeField(
	'yesno',
	'page_title_whole_content_animations',
	'no',
	esc_html__( 'Enable Whole Title Content Animation', 'hudson' ),
	esc_html__( 'This option will enable whole title content animation', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_title_whole_content_animations_container'
	)
);
$panel9->addChild(
	'page_title_whole_content_animations',
	$page_title_whole_content_animations
);

$page_title_whole_content_animations_container = new HudsonEdgeContainer(
	'page_title_whole_content_animations_container',
	'page_title_whole_content_animations',
	'no'
);
$panel9->addChild(
	'page_title_whole_content_animations_container',
	$page_title_whole_content_animations_container
);

$page_title_whole_content_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_title_whole_content_animations_container->addChild(
	'page_title_whole_content_animations_data_start',
	$page_title_whole_content_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_title_whole_content_animations_data_start->addChild(
	'row1',
	$row1
);

$page_title_whole_content_data_start = new HudsonEdgeField(
	'textsimple',
	'page_title_whole_content_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_title_whole_content_data_start',
	$page_title_whole_content_data_start
);

$page_title_whole_content_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_whole_content_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_title_whole_content_start_custom_style',
	$page_title_whole_content_start_custom_style
);

$page_title_whole_content_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_title_whole_content_animations_container->addChild(
	'page_title_whole_content_animations_data_end',
	$page_title_whole_content_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_title_whole_content_animations_data_end->addChild(
	'row2',
	$row2
);

$page_title_whole_content_data_end = new HudsonEdgeField(
	'textsimple',
	'page_title_whole_content_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_title_whole_content_data_end',
	$page_title_whole_content_data_end
);

$page_title_whole_content_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_whole_content_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_title_whole_content_end_custom_style',
	$page_title_whole_content_end_custom_style
);

//Title Animations
$animation_page_title_contaier = new HudsonEdgeContainerNoStyle(
	'animation_page_title_contaier',
	'show_page_title_text',
	'no'
);
$panel9->addChild(
	'animation_page_title_contaier',
	$animation_page_title_contaier
);

$page_title_animations = new HudsonEdgeField(
	'yesno',
	'page_title_animations',
	'no',
	esc_html__( 'Enable Page Title Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Scroll Animations', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_title_animations_container'
	)
);
$animation_page_title_contaier->addChild(
	'page_title_animations',
	$page_title_animations
);

$page_title_animations_container = new HudsonEdgeContainer(
	'page_title_animations_container',
	'page_title_animations',
	'no'
);
$animation_page_title_contaier->addChild(
	'page_title_animations_container',
	$page_title_animations_container
);

$page_title_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_title_animations_container->addChild(
	'page_title_animations_data_start',
	$page_title_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_title_animations_data_start->addChild(
	'row1',
	$row1
);

$page_title_data_start = new HudsonEdgeField(
	'textsimple',
	'page_title_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_title_data_start',
	$page_title_data_start
);

$page_title_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_title_start_custom_style',
	$page_title_start_custom_style
);

$page_title_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_title_animations_container->addChild(
	'page_title_animations_data_end',
	$page_title_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_title_animations_data_end->addChild(
	'row2',
	$row2
);

$page_title_data_end = new HudsonEdgeField(
	'textsimple',
	'page_title_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_title_data_end',
	$page_title_data_end
);

$page_title_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_title_end_custom_style',
	$page_title_end_custom_style
);

//Title Separator Animations
$animation_page_title_separator_container = new HudsonEdgeContainerNoStyle(
	'animation_page_title_separator_container',
	'title_separator',
	'no'
);
$panel9->addChild(
	'animation_page_title_separator_container',
	$animation_page_title_separator_container
);

$page_title_separator_animations = new HudsonEdgeField(
	'yesno',
	'page_title_separator_animations',
	'no',
	esc_html__( 'Enable Page Separator Title Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Separator Scroll Animations', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_title_separator_animations_container'
	)
);
$animation_page_title_separator_container->addChild(
	'page_title_separator_animations',
	$page_title_separator_animations
);

$page_title_separator_animations_container = new HudsonEdgeContainer(
	'page_title_separator_animations_container',
	'page_title_separator_animations',
	'no'
);
$animation_page_title_separator_container->addChild(
	'page_title_separator_animations_container',
	$page_title_separator_animations_container
);

$page_title_separator_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_title_separator_animations_container->addChild(
	'page_title_separator_animations_data_start',
	$page_title_separator_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_title_separator_animations_data_start->addChild(
	'row1',
	$row1
);

$page_title_separator_data_start = new HudsonEdgeField(
	'textsimple',
	'page_title_separator_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_title_separator_data_start',
	$page_title_separator_data_start
);

$page_title_separator_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_separator_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_title_separator_start_custom_style',
	$page_title_separator_start_custom_style
);

$page_title_separator_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_title_separator_animations_container->addChild(
	'page_title_separator_animations_data_end',
	$page_title_separator_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_title_separator_animations_data_end->addChild(
	'row2',
	$row2
);

$page_title_separator_data_end = new HudsonEdgeField(
	'textsimple',
	'page_title_separator_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_title_separator_data_end',
	$page_title_separator_data_end
);

$page_title_separator_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_separator_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_title_separator_end_custom_style',
	$page_title_separator_end_custom_style
);

//Subtitle Animations
$page_subtitle_animations = new HudsonEdgeField(
	'yesno',
	'page_subtitle_animations',
	'no',
	esc_html__( 'Enable Page Subtitle Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Subtitle Scroll Animations', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_subtitle_animations_container'
	)
);
$panel9->addChild(
	'page_subtitle_animations',
	$page_subtitle_animations
);

$page_subtitle_animations_container = new HudsonEdgeContainer(
	'page_subtitle_animations_container',
	'page_subtitle_animations',
	'no'
);
$panel9->addChild(
	'page_subtitle_animations_container',
	$page_subtitle_animations_container
);

$page_subtitle_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_subtitle_animations_container->addChild(
	'page_subtitle_animations_data_start',
	$page_subtitle_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_subtitle_animations_data_start->addChild(
	'row1',
	$row1
);

$page_subtitle_data_start = new HudsonEdgeField(
	'textsimple',
	'page_subtitle_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_subtitle_data_start',
	$page_subtitle_data_start
);

$page_subtitle_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_subtitle_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_subtitle_start_custom_style',
	$page_subtitle_start_custom_style
);

$page_subtitle_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_subtitle_animations_container->addChild(
	'page_subtitle_animations_data_end',
	$page_subtitle_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_subtitle_animations_data_end->addChild(
	'row2',
	$row2
);

$page_subtitle_data_end = new HudsonEdgeField(
	'textsimple',
	'page_subtitle_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_subtitle_data_end',
	$page_subtitle_data_end
);

$page_subtitle_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_subtitle_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_subtitle_end_custom_style',
	$page_subtitle_end_custom_style
);

//Graphic Animations
$page_title_graphic_animations = new HudsonEdgeField(
	'yesno',
	'page_title_graphic_animations',
	'no',
	esc_html__( 'Enable Page Title Graphic Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Graphic Scroll Animations', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_title_graphic_animations_container'
	)
);
$panel9->addChild(
	'page_title_graphic_animations',
	$page_title_graphic_animations
);

$page_title_graphic_animations_container = new HudsonEdgeContainer(
	'page_title_graphic_animations_container',
	'page_title_graphic_animations',
	'no'
);
$panel9->addChild(
	'page_title_graphic_animations_container',
	$page_title_graphic_animations_container
);

$page_title_graphic_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_title_graphic_animations_container->addChild(
	'page_title_graphic_animations_data_start',
	$page_title_graphic_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_title_graphic_animations_data_start->addChild(
	'row1',
	$row1
);

$page_title_graphic_data_start = new HudsonEdgeField(
	'textsimple',
	'page_title_graphic_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_title_graphic_data_start',
	$page_title_graphic_data_start
);

$page_title_graphic_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_graphic_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_title_graphic_start_custom_style',
	$page_title_graphic_start_custom_style
);

$page_title_graphic_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_title_graphic_animations_container->addChild(
	'$page_title_graphic_animations_data_end',
	$page_title_graphic_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_title_graphic_animations_data_end->addChild(
	'row2',
	$row2
);

$page_title_graphic_data_end = new HudsonEdgeField(
	'textsimple',
	'page_title_graphic_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_title_graphic_data_end',
	$page_title_graphic_data_end
);

$page_title_graphic_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_graphic_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_title_graphic_end_custom_style',
	$page_title_graphic_end_custom_style
);

//Breadcrumb animations
$animation_page_title_breadcrumbs_container = new HudsonEdgeContainerNoStyle(
	'animation_page_title_breadcrumbs_container',
	'enable_breadcrumbs',
	'no'
);
$panel9->addChild(
	'animation_page_title_breadcrumbs_container',
	$animation_page_title_breadcrumbs_container
);

$page_title_breadcrumbs_animations = new HudsonEdgeField(
	'yesno',
	'page_title_breadcrumbs_animations',
	'no',
	esc_html__( 'Enable Page Title Breadcrumbs Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Breadcrumbs Scroll Animations', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_page_title_breadcrumbs_animations_container'
	)
);
$animation_page_title_breadcrumbs_container->addChild(
	'page_title_breadcrumbs_animations',
	$page_title_breadcrumbs_animations
);

$page_title_breadcrumbs_animations_container = new HudsonEdgeContainer(
	'page_title_breadcrumbs_animations_container',
	'page_title_breadcrumbs_animations',
	'no'
);
$animation_page_title_breadcrumbs_container->addChild(
	'page_title_breadcrumbs_animations_container',
	$page_title_breadcrumbs_animations_container
);

$page_title_breadcrumbs_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_title_breadcrumbs_animations_container->addChild(
	'page_title_breadcrumbs_animations_data_start',
	$page_title_breadcrumbs_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_title_breadcrumbs_animations_data_start->addChild(
	'row1',
	$row1
);

$page_title_breadcrumbs_data_start = new HudsonEdgeField(
	'textsimple',
	'page_title_breadcrumbs_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_title_breadcrumbs_data_start',
	$page_title_breadcrumbs_data_start
);

$page_title_breadcrumbs_start_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_breadcrumbs_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_title_breadcrumbs_start_custom_style',
	$page_title_breadcrumbs_start_custom_style
);

$page_title_breadcrumbs_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_title_breadcrumbs_animations_container->addChild(
	'page_title_breadcrumbs_animations_data_end',
	$page_title_breadcrumbs_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_title_breadcrumbs_animations_data_end->addChild(
	'row2',
	$row2
);

$page_title_breadcrumbs_data_end = new HudsonEdgeField(
	'textsimple',
	'page_title_breadcrumbs_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_title_breadcrumbs_data_end',
	$page_title_breadcrumbs_data_end
);

$page_title_breadcrumbs_end_custom_style = new HudsonEdgeField(
	'textareasimple',
	'page_title_breadcrumbs_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_title_breadcrumbs_end_custom_style',
	$page_title_breadcrumbs_end_custom_style
);